<?php
/*
Plugin Name: Moose Instagram Feed
Description: Plugin that adds Instagram feed functionality to our theme
Author: Elated Themes
Version: 1.0
*/

define('MOOSE_INSTAGRAM_FEED_VERSION', '1.0');
define('MOOSE_INSTAGRAM_ABS_PATH', dirname(__FILE__));
define('MOOSE_INSTAGRAM_REL_PATH', dirname(plugin_basename(__FILE__ )));
define( 'MOOSE_INSTAGRAM_URL_PATH', plugin_dir_url( __FILE__ ) );
define( 'MOOSE_INSTAGRAM_ASSETS_PATH', MOOSE_INSTAGRAM_ABS_PATH . '/assets' );
define( 'MOOSE_INSTAGRAM_ASSETS_URL_PATH', MOOSE_INSTAGRAM_URL_PATH . 'assets' );
define( 'MOOSE_INSTAGRAM_SHORTCODES_PATH', MOOSE_INSTAGRAM_ABS_PATH . '/shortcodes' );
define( 'MOOSE_INSTAGRAM_SHORTCODES_URL_PATH', MOOSE_INSTAGRAM_URL_PATH . 'shortcodes' );

include_once 'load.php';

if ( ! function_exists( 'moose_instagram_theme_installed' ) ) {
    /**
     * Checks whether theme is installed or not
     * @return bool
     */
    function moose_instagram_theme_installed() {
        return defined( 'MOOSE_ELATED' );
    }
}

if ( ! function_exists( 'moose_instagram_feed_text_domain' ) ) {
	/**
	 * Loads plugin text domain so it can be used in translation
	 */
	function moose_instagram_feed_text_domain() {
		load_plugin_textdomain( 'moose-instagram-feed', false, MOOSE_INSTAGRAM_REL_PATH . '/languages' );
	}
	
	add_action( 'plugins_loaded', 'moose_instagram_feed_text_domain' );
}